<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HealthProfile extends Model 
{

    protected $table = 'Health_profiles';
    public $timestamps = false;

    public function weight()
    {
        return $this->hasMany('SmartScale');
    }

    public function height()
    {
        return $this->hasMany('Height');
    }

    public function medicalHistory()
    {
        return $this->hasMany('MedicalHistory');
    }

    public function heartbeat()
    {
        return $this->hasMany('Heartbeat');
    }

    public function temperature()
    {
        return $this->hasMany('Temperature');
    }

    public function bloodPressure()
    {
        return $this->hasMany('BloodPressure');
    }

    public function file()
    {
        return $this->hasMany('File');
    }

}